<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\PostTags;
use App\Tags;
use Session;

class TagsController extends Controller
{
    public function all()
    {

        $tags = Tags::all();

        foreach ($tags as $t) {
            $t->post_count = PostTags::where('tag_id', $t->id)->count();
        }

        return view('admin.tags.all', ['tags' => $tags]);
    }

    public function delete($id)
    {
        if (!is_null($id) && sizeof(Tags::where('id', $id)->get()) > 0) {

            PostTags::where('tag_id', $id)->delete();
            Tags::where('id', $id)->delete();

            Session::flash('success_msg', 'Tag deleted successfully');
            return redirect()->to('/admin/tags/all');

        } else {
            Session::flash('error_msg', 'Tag not found');
            return redirect()->to('/admin/tags/all');
        }
    }

}